# LDSScriptures.pl
# Movable Type plugin filter for automatically linking
# LDS scripture references to online scriptures
# Copyright 2003 by Eric James Stone
# http://www.ericjamesstone.com/
# version 1.01
# last modified 9 October 2003

package MT::Plugin::LDSscriptures;
use MT::Template::Context;
MT::Template::Context->add_global_filter(lds_scriptures => sub { &lds_scriptures });
sub lds_scriptures { 

  my $text = shift;
  my $arg_value = shift;
  my $ctx = shift;
	if ($arg_value) {
		$books{'gen'} = '\bGenesis|\bGen';
		$books{'ex'} = '\bExodus|\bEx';
		$books{'lev'} = '\bLeviticus|\bLev';
		$books{'num'} = '\bNumbers|\bNum';
		$books{'deut'} = '\bDeuteronomy|\bDeut';
		$books{'josh'} = '\bJoshua|\bJosh';
		$books{'judg'} = '\bJudges|\bJudg';
		$books{'ruth'} = '\bRuth';
		$books{'1_sam'} = '\bFirst Samuel|\bI Samuel|\b1 Samuel|\b1 Sam';
		$books{'2_sam'} = '\bSecond Samuel|\bII Samuel|\b2 Samuel|\b2 Sam';
		$books{'1_kgs'} = '\bFirst Kings|\bI Kings|\b1 Kings|\b1 Kgs';
		$books{'2_kgs'} = '\bSecond Kings|\bII Kings|\b2 Kings|\b2 Kgs';
		$books{'1_chr'} = '\bFirst Chronicles|\bI Chronicles|\b1 Chronicles|\b1 Chr';
		$books{'2_chr'} = '\bSecond Chronicles|\bII Chronicles|\b2 Chronicles|\b2 Chr';
		$books{'ezra'} = '\bEzra';
		$books{'neh'} = '\bNehemiah|\bNeh';
		$books{'esth'} = '\bEsther|\bEsth';
		$books{'job'} = '\bJob|\bJob';
		$books{'ps'} = '\bPsalms|\bPs';
		$books{'prov'} = '\bProverbs|\bProv';
		$books{'eccl'} = '\bEcclesiastes|\bEccl';
		$books{'song'} = '\bSong of Solomon|\bSong';
		$books{'isa'} = '\bIsaiah|\bIsa';
		$books{'jer'} = '\bJeremiah|\bJer';
		$books{'lam'} = '\bLamentations|\bLam';
		$books{'ezek'} = '\bEzekiel|\bEzek';
		$books{'dan'} = '\bDaniel|\bDan';
		$books{'hosea'} = '\bHosea';
		$books{'joel'} = '\bJoel';
		$books{'amos'} = '\bAmos';
		$books{'obad'} = '\bObadiah|\bObad';
		$books{'jonah'} = '\bJonah';
		$books{'micah'} = '\bMicah';
		$books{'nahum'} = '\bNahum';
		$books{'hab'} = '\bHabakkuk|\bHab';
		$books{'zeph'} = '\bZephaniah|\bZeph';
		$books{'hag'} = '\bHaggai|\bHag';
		$books{'zech'} = '\bZechariah|\bZech';
		$books{'mal'} = '\bMalachi|\bMal';
		$books{'mark'} = '\bMatt';
		$books{'mark'} = '\bMark';
		$books{'luke'} = '\bLuke';
		$books{'john'} = '\bJohn';
		$books{'acts'} = '\bActs|\bActs of the Apostles';
		$books{'rom'} = '\bRomans|\bRom';
		$books{'1_cor'} = '\bFirst Corinthians|\bI Corinthians|\b1 Corinthians|\b1 Cor';
		$books{'2_cor'} = '\bSecond Corinthians|\bII Corinthians|\b2 Corinthians|\b2 Cor';
		$books{'gal'} = '\bGalatians|\bGal';
		$books{'eph'} = '\bEphesians|\bEph';
		$books{'philip'} = '\bPhilippians|\bPhilip';
		$books{'col'} = '\bColossians|\bCol';
		$books{'1_thes'} = '\bFirst Thessalonians|\bI Thessalonians|\b1 Thessalonians|\b1 Thes';
		$books{'2_thes'} = '\bSecond Thessalonians|\bII Thessalonians|\b2 Thessalonians|\b2 Thes';
		$books{'1_tim'} = '\bFirst Timothy|\b1 Timothy|\b1 Tim';
		$books{'2_tim'} = '\bSecond Timothy|\b2 Timothy|\b2 Tim';
		$books{'titus'} = '\bTitus';
		$books{'philem'} = '\bPhilemon|\bPhilem';
		$books{'heb'} = '\bHebrews|\bHeb';
		$books{'james'} = '\bJames|\bJames';
		$books{'1_pet'} = '\bFirst Peter|\b1 Peter|\b1 Pet';
		$books{'2_pet'} = '\bSecond Peter|\b2 Peter|\b2 Pet';
		$books{'1_jn'} = '\bFirst John|\b1 John|\b1 Jn';
		$books{'2_jn'} = '\bSecond John|\b2 John|\b2 Jn';
		$books{'3_jn'} = '\bThird John|\b3 John|\b3 Jn';
		$books{'jude'} = '\bJude';
		$books{'rev'} = '\bRevelations|\bRevelation|\bRev';
		$books{'1_ne'} = '\bFirst Nephi|\b1st Nephi|\b1 Nephi|\b1 Ne';
		$books{'2_ne'} = '\bSecond Nephi|\b2nd Nephi|\b2 Nephi|\b2 Ne';
		$books{'jacob'} = '\bJacob';
		$books{'enos'} = '\bEnos';
		$books{'jarom'} = '\bJarom';
		$books{'omni'} = '\bOmni';
		$books{'w_of_m'} = '\bWords of Mormon|\bW\.* of M|\bWoM';
		$books{'mosiah'} = '\bMosiah';
		$books{'alma'} = '\bAlma';
		$books{'hel'} = '\bHelaman|\bHel';
		$books{'3_ne'} = '\bThird Nephi|\b3rd Nephi|\b3 Nephi|\b3 Ne';
		$books{'4_ne'} = '\bFourth Nephi|\b4th Nephi|\b4 Nephi|\b4 Ne';
		$books{'morm'} = '\bMormon|\bMorm';
		$books{'ether'} = '\bEther';
		$books{'moro'} = '\bMoroni|\bMoro';
		$books{'dc'} = '\bDoctrine and Covenants|\bDoctrine & Covenants|\bDoctrine &amp; Covenants|\bD&C|\bD&amp;C|\bD & C|\bD &amp; C';
		$books{'moses'} = '\bMoses';
		$books{'abr'} = '\bAbraham|\bAbr';
		$books{'js_m'} = '\bJoseph Smith.Matthew|\bJoseph Smith . Matthew|\bJS-M';
		$books{'js_h'} = '\bJoseph Smith.History|\bJoseph Smith . History|\bJS-H';
		$aof = '\bArticles of Faith|\bArticle of Faith|\bAoF|\bA of F|\bA\. of F\.';

		$start="<A target=_blank HREF='http:\/\/scriptures.lds.org";
		$end="'>";

		if ($arg_value==2) {
			$start="<A HREF='javascript:void window.open(\"http:\/\/scriptures.lds.org";
			$end="\",\"LDSS\",\"location=yes,directories=yes,menubar=yes,resizable=yes,scrollbars=yes,status=yes,toolbar=yes,height=400,width=560\");'>";
		}
		@key_names = keys(%books);
	
		foreach $key (@key_names) {
			$text=~s%(($books{$key}\.?)\s+(\d+):*((\d+)[\d\s\-,]*))%$start\/$key\/$3\/$4#$5$end$1<\/a>%ig; 
			$text=~s%(($books{$key}\.?)\s+(\d+))([^\:\d])%$start\/$key\/$3$end$1<\/a>$4%ig; 
		}
		$text=~s%([^\-\s]\s*)((\bmatthew\.?)\s+(\d+):*((\d+)[\d\s\-,]*))%$1$start\/matt\/$4\/$5#$6$end$2<\/a>%ig; 
		$text=~s%([^\-\s]\s*)((\bmatthew\.?)\s+(\d+))([^\:\d])%$1$start\/matt\/$4$end$2<\/a>$5%ig; 
		$text=~s%(($aof\.?)\s+(\d+))%$start\/a_of_f\/1/$3$end$1<\/a>%ig; 
		$text=~s%(($aof\.?)(\s*[^\d]))%$start\/a_of_f/1$end$2<\/a>$3%g; 
	}
  return $text;
}
1;